/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: EipObject_diag.h 67121 2017-02-09 17:30:05Z MarcBommert $:

Description:
  Diagnosis Codes of the EthernetIP Object task

**************************************************************************************/

#ifndef __EIP_OBJECT_DIAG_H
#define __EIP_OBJECT_DIAG_H

/////////////////////////////////////////////////////////////////////////////////////
// Ethernet/IP Object
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_DIAG_E_EIP_OBJECT_NO_SERVICE_RES_PACKET
//
// MessageText:
//
//  No free packet available to create a response of the request.
//
#define TLR_DIAG_E_EIP_OBJECT_NO_SERVICE_RES_PACKET ((TLR_RESULT)0xC01F0001L)

//
// MessageId: TLR_DIAG_E_EIP_OBJECT_NO_GET_INP_PACKET
//
// MessageText:
//
//  No free packet available to send the input data.
//
#define TLR_DIAG_E_EIP_OBJECT_NO_GET_INP_PACKET ((TLR_RESULT)0xC01F0002L)

//
// MessageId: TLR_DIAG_E_EIP_OBJECT_ROUTING_SEND_PACKET_FAIL
//
// MessageText:
//
//  Routing a request to an object failed. A error ouccurred at the destination packet queue.
//
#define TLR_DIAG_E_EIP_OBJECT_ROUTING_SEND_PACKET_FAIL ((TLR_RESULT)0xC01F0003L)

//
// MessageId: TLR_DIAG_E_EIP_OBJECT_ROUTING_SEND_PACKET_CNF_FAIL
//
// MessageText:
//
//  Sending the confirmation of a request failed. A error ouccurred at the packet queue.
//
#define TLR_DIAG_E_EIP_OBJECT_ROUTING_SEND_PACKET_CNF_FAIL ((TLR_RESULT)0xC01F0004L)

//
// MessageId: TLR_DIAG_E_EIP_OBJECT_GETTING_UNKNOWN_CLASS_ID
//
// MessageText:
//
//  Getting a confirmation of a request from a unknown object.
//
#define TLR_DIAG_E_EIP_OBJECT_GETTING_UNKNOWN_CLASS_ID ((TLR_RESULT)0xC01F0005L)

//
// MessageId: TLR_DIAG_E_EIP_OBJECT_NO_CC_INSTANCE_MEMORY
//
// MessageText:
//
//  Instance of the CC object could not created. No free memory available.
//
#define TLR_DIAG_E_EIP_OBJECT_NO_CC_INSTANCE_MEMORY ((TLR_RESULT)0xC01F0006L)

//
// MessageId: TLR_DIAG_E_EIP_OBJECT_CLOSE_SEND_PACKET_FAIL
//
// MessageText:
//
//  Completing a connection close command failed. Sending the command to the packet queue failed.
//
#define TLR_DIAG_E_EIP_OBJECT_CLOSE_SEND_PACKET_FAIL ((TLR_RESULT)0xC01F0007L)

//
// MessageId: TLR_DIAG_E_EIP_OBJECT_OPEN_SEND_PACKET_FAIL
//
// MessageText:
//
//  Completing a connection open command failed. Sending the command to the packet queue failed.
//
#define TLR_DIAG_E_EIP_OBJECT_OPEN_SEND_PACKET_FAIL ((TLR_RESULT)0xC01F0008L)

//
// MessageId: TLR_DIAG_E_EIP_OBJECT_DEL_TRANSP_SEND_PACKET_FAIL
//
// MessageText:
//
//  Sending the delete transport command failed. Encap Queue signal an error.
//
#define TLR_DIAG_E_EIP_OBJECT_DEL_TRANSP_SEND_PACKET_FAIL ((TLR_RESULT)0xC01F0009L)

//
// MessageId: TLR_DIAG_E_EIP_OBJECT_FW_OPEN_SEND_PACKET_FAIL
//
// MessageText:
//
//  Sending the forward open command failed. Encap Queue signal an error.
//
#define TLR_DIAG_E_EIP_OBJECT_FW_OPEN_SEND_PACKET_FAIL ((TLR_RESULT)0xC01F000AL)

//
// MessageId: TLR_DIAG_E_EIP_OBJECT_START_TRANSP_SEND_PACKET_FAIL
//
// MessageText:
//
//  Sending the start transport command failed. Encap Queue signal an error.
//
#define TLR_DIAG_E_EIP_OBJECT_START_TRANSP_SEND_PACKET_FAIL ((TLR_RESULT)0xC01F000BL)

//
// MessageId: TLR_DIAG_E_EIP_OBJECT_CM_UNKNOWN_CNF
//
// MessageText:
//
//  Connection manager received a confirmation of unknown service.
//
#define TLR_DIAG_E_EIP_OBJECT_CM_UNKNOWN_CNF ((TLR_RESULT)0xC01F000CL)

//
// MessageId: TLR_DIAG_E_EIP_OBJECT_FW_CLOSE_SEND_PACKET_FAIL
//
// MessageText:
//
//  Sending the forward close command failed. Encap Queue signal an error.
//
#define TLR_DIAG_E_EIP_OBJECT_FW_CLOSE_SEND_PACKET_FAIL ((TLR_RESULT)0xC01F000DL)

//
// MessageId: TLR_DIAG_E_EIP_OBJECT_NO_RESET_PACKET
//
// MessageText:
//
//  Fail to complete reset command. We did not get a empty packet.
//
#define TLR_DIAG_E_EIP_OBJECT_NO_RESET_PACKET ((TLR_RESULT)0xC01F000EL)

//
// MessageId: TLR_DIAG_E_EIP_OBJECT_NO_CHANGE_INDICATION_RESOURCE
//
// MessageText:
//
//  Failed to get a free resource to handle an object change indication towards the host
//
#define TLR_DIAG_E_EIP_OBJECT_NO_CHANGE_INDICATION_RESOURCE ((TLR_RESULT)0xC01F000FL)


#endif  //__EIP_OBJECT_DIAG_H

